<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;

class AdminController extends Controller
{
    
    public function loginView(): View
    {
        return view('admin.login');
    }
    
    public function authLogin(Request $request): RedirectResponse
    {
        $data = $request->all();
        $validate = array();
        $validate['email'] = 'required|email';
        $validate['password'] = 'required';
        $request->validate($validate);

        if (Auth::guard('web')->attempt(['email' => $data['email'], 'password' => $data['password'], 'status' => 'Active'])) {
            return redirect()->route('admin.dashboard')->with(['msg' => 'You are logged in successfully', 'status' => 'success']);
        } else {
            return redirect()->route('admin.login')->with(['msg' => 'Please Check Your Credentials', 'status' => 'error']);
        }
    }

    public function dashboardView(): View
    {
        return view('admin.dashboard');
    }

    public function logout(): RedirectResponse
    {
        Auth::guard('web')->logout();
        return redirect()->route('admin.login')->with(['msg' => 'You are logged out successfully', 'status' => 'success']);
    }
}
